<?php
require_once '../../config/config.php';
require_once '../../config/auth.php';
require_once '../../config/database.php';
require_once '../../helpers/format_uang.php';
require_once '../../helpers/tanggal.php';

require_once '../../templates/header.php';
require_once '../../templates/sidebar.php';

$where = "";
if (!empty($_GET['dari']) && !empty($_GET['sampai'])) {
    $dari   = $_GET['dari'];
    $sampai = $_GET['sampai'];
    $where  = "WHERE DATE(tanggal) BETWEEN '$dari' AND '$sampai'";
}

$laporan = $db->query("
    SELECT 
        COUNT(id) AS total_transaksi,
        SUM(jumlah) AS total_barang,
        SUM(total) AS total_pemasukan
    FROM kasir_transaksi
    $where
");
$data = $laporan->fetch_assoc();
?>

<h2>Laporan Kasir</h2>

<form method="get">
    Dari: <input type="date" name="dari" required>
    Sampai: <input type="date" name="sampai" required>
    <button type="submit">Tampilkan</button>
</form>

<hr>

<table class="table">
    <tr>
        <th>Total Transaksi</th>
        <td><?= $data['total_transaksi']; ?></td>
    </tr>
    <tr>
        <th>Total Barang Terjual</th>
        <td><?= $data['total_barang']; ?></td>
    </tr>
    <tr>
        <th>Total Pemasukan</th>
        <td><?= format_uang($data['total_pemasukan']); ?></td>
    </tr>
</table>

<?php require_once '../../templates/footer.php'; ?>
